//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 PaleVioletRed
#property indicator_width1 2
#property indicator_level1 0

#import "libSSA.dll"
   void fastSingular(double& sourceArray[],int arraySize, int lag, int numberOfComputationLoops, double& destinationArray[]);
#import

//
//
//
//
//

extern int SSAPrice                =  PRICE_CLOSE;
extern int SSALag                  = 25;
extern int SSANumberOfComputations =  2;
extern int SSAPeriodNormalization  = 10;
extern int SSANumberOfBars         = 300;
extern int FirstBar                = 300; 

//
//
//
//
//

double in[];
double no[];
double ssaIn[];
double ssaOut[];

//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(2);
      SetIndexBuffer(0,in);
      SetIndexBuffer(1,no);
   IndicatorShortName("SSA normalized end-pointed");
   return(0);
}
int deinit(){return(0);}

//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int i,limit,counted_bars = IndicatorCounted();

      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);

   //
   //
   //
   //
   //
      
   for(i=limit; i>=0; i--)
   {
      double ma    = iMA(NULL,0,SSAPeriodNormalization,0,MODE_SMA,SSAPrice,i);
      double dev   = iStdDev(NULL,0,SSAPeriodNormalization,0,MODE_SMA,SSAPrice,i)*3.0;
      double price = iMA(NULL,0,1,0,MODE_SMA,SSAPrice,i);
             no[i] = (price-ma)/(MathMax(dev,0.000001));
            
         //
         //
         //
         //
         //
            
         if (i<=FirstBar)
         {
            int ssaBars = MathMin(Bars-i,SSANumberOfBars);
            if (ssaBars<SSALag) continue;
               if (ArraySize(ssaIn) != ssaBars)
               {
                  ArrayResize(ssaIn ,ssaBars);
                  ArrayResize(ssaOut,ssaBars);
               }
               ArrayCopy(ssaIn,no,0,i,ssaBars);
 
            fastSingular(ssaIn,ssaBars,SSALag,SSANumberOfComputations,ssaOut);
            in[i]=ssaOut[0];
         }                   
   }                  
   return(0); 
}